---
title: Backing services
weight: 1
---

[Backing services](https://12factor.net/backing-services) are necessary to any web application you deploy.
In our example, we'll need a prostgres database.

So, we'll need to deploy a postgres database on kubernetes. For that we'll use an operator. There are currently [around 5 different postgres operators](https://github.com/operator-framework/awesome-operators). Libre.sh curated one for you, the one developped by [Zalando](https://github.com/zalando/postgres-operator).

Once you have [the operator running](https://github.com/zalando/postgres-operator/blob/master/docs/quickstart.md) in your cluster, we can deploy a postgres instance.

With the kubernetes API that is declarative, this is how you'd do:

```
cat << EOF | kubectl apply -f -
apiVersion: "acid.zalan.do/v1"
kind: postgresql
metadata:
  name: nextcloud-postgres
  namespace: fight-marketing
spec:
  teamId: "nextcloud"
  volume:
    size: 1Gi
  numberOfInstances: 2
  users:
    nextcloud:  # database owner
    - superuser
    - createdb
  databases:
    nextcloud: nextcloud  # dbname: owner
  postgresql:
    version: "11"
EOF
```

After some minutes, you get a highly available Postgres cluster running. Nice right? Now let's deploy Nextcloud.