---
title: Libre.sh operator
weight: 20
---

As explained at the begining, libre.sh is a distribution where services are curated and integrated together.
We assume that you use the zalando postgres operator. We also know the domain name from the annotation in the namespace.

So then we can build a libre.sh Nextcloud operator (still to be built).

And deploying a Nextcloud instance would look like this:

```
cat << EOF | kubectl -f -
apiVersion: "nextcloud.libre.sh/v1"
kind: cloud
metadata:
  name: fight-marketing
  namespace: fight-marketing
EOF
```

Or put differently:

```
curl https://yourkubernetes.cluster/nextcloud.libre.sh/v1/cloud/ -k -H "Content-Type: application/json" -XPOST -d '
{
    "apiVersion": "nextcloud.libre.sh/v1",
    "kind": "cloud",
    "metadata": {
        "name": "fight-marketing",
        "namespace": "fight-marketing",
    }
}'
```

And yes, you can use an OpenIdConnect provider with RuleBasedAccessControl in front of the kubernetes api if you see where we are going ;)

You could also imagine adding a spec, like `size: L`, and it would translate into a price and cpu and memory request for the different components.