---
title: Upstream operator
weight: 10
---

Now that Postgres is running, we can deploy our Nextcloud.

But first we need to deploy the nextcloud upstream operator. This operator is low level because it would need every information about the backing services. It is a nice building block for projects like libre.sh.

Here is the version alpha we are developing. The goal is to move it's development upstream. We think that this belongs to Nextcloud community to own this. And we'll help bootstrap that. The same way we did with [some](https://github.com/RocketChat/Docker.Official.Image/commit/a951f488fb2a633fc89ad3048eb451aa05dc90ee) [official](https://github.com/nextcloud/docker/commit/8fa384bcd6619b9c19c5efbcdf7248d803e43727) [docker](https://github.com/matomo-org/docker/commit/e6538b90a4c7e7e3d6423d1e4740e674ee42eede) [images](https://github.com/idno/Known-Docker/commit/394e91c21d33914899dd2b0b211be2d7fe4e1837).

Here is how the Nextcloud instance object would look like:

```
cat << EOF | kubectl apply -f -
apiVersion: "nextcloud.com/v1"
kind: nextcloud
metadata:
  name: cloud
  namespace: fight-marketing
spec:
  postgress:
    endpoint: nextcloud-postgres
    secret: nextcloud-postgres-secret
  volume:
    size: 1Gi
  numberOfInstances: 2
  domainNames:
    - fight.marketing
EOF
```

After some minutes, you'd get an up and running Nextcloud instance. behind the scene it would have provisionned the following:

 - the deployment with 2 pods with a php container with Nextcloud code
 - a cron job
 - a web container to serve static assets
 - an ingress with a Let's Encrypt certificate
 - installed Nextcloud

Upstream operators are already nice you'd say. But keep in mind that we are discussing about 7 backing services. So for each Nextcloud instance, you'd need to do the plumbing manually of each backing service manually. Let's go now to the libre.sh operator.