---
title: Operators
weight: 3
---

As we saw in the previous paragraph, kubernetes is now the standard cloud API. But kubernetes, the open source upstream project is really narrowed.
It doesn't want to make everything, and want to stay focus on the good foundations.

#### Resources

A popular analogy is that kubernetes is providing the lego bricks so that you can build the Pirate ship yourself. These bricks are the resources.

At the beginning, when you deploy kubernetes, you get these lego bricks, the resources that make a cloud API:

 - pods (compute and memory) - they are composed of containers
 - service (L4 load balancer)
 - ...

One way to extend the kubernetes API, is with what is called Custom Resource Definition (CRD).

#### History

The concept of operator was first introduced by [CoreOS in this blog post](https://coreos.com/blog/introducing-operators.html), and we recommend you to read it. We got immediately excited, and now all the industry is speaking about it. There is even a WordPress operator (More on that later).

#### Why is it so exciting

Operators are a way to write as code the lifecycle of an hosted app, in our case a free software hosted app.
It is probably the first time in IT history that we can collaborate about how to:

 - install
 - delete
 - update
 - backup
 - restore
 - scale
 - run highly available

These recipes can now be code. It means they can be tested and shared with a Freesoftware license.

The combination of kubernetes and operators on not is really appealing as a platform to run free software hosted apps.
