# Libre.sh - Kubernetes the libre way.

## Introduction

The current status of the project is pre-alpha. It is mostly documentation but should already be helpful. The plan is to automatize more parts.

Libre.sh is a kubernetes distribution aimed at hosting freesoftware for the people. Think of it as  the debian of kubernetes distribution for hosted software, or as a distributed yunohost.

 - Currently contains documentation - From Hetzner to Nextcloud
 - No single point of faillure
 - Scallable
 - High density of services
 - Everything as code
 
## How it works

It is an opinionated but modular kubernetes distribution. We don't have a strong opinion about lower layers, but we want to collaborate on top. The aim of this distribution is to host free software for people and organisation at scale.

Like for libre.sh v1 - yet another docker-compose PaaS, we use the best FLOSS tools out there, put them together, add a bit of configuration, make upstream compatible and enjoy the ride.

In our case, once you got kubernetes working, the rest is based on operators.

We have one opinion on how to organize the cluster, is that, we namespace it by domain name, and we put this domain as an annotation, it allows us for some automation later.

Then we curate a list of nice operators for the backing services (Think s3, postgres, redis, emails..).

We also need to build/advocate for upstream operators for popular FLOSS projects. We already helped develop [some](https://github.com/RocketChat/Docker.Official.Image/commit/a951f488fb2a633fc89ad3048eb451aa05dc90ee) [official](https://github.com/nextcloud/docker/commit/8fa384bcd6619b9c19c5efbcdf7248d803e43727) [docker](https://github.com/matomo-org/docker/commit/e6538b90a4c7e7e3d6423d1e4740e674ee42eede) [images](https://github.com/idno/Known-Docker/commit/394e91c21d33914899dd2b0b211be2d7fe4e1837) on the v1, we now want to help develop this operators.

Then we wrap these operators as  libre.sh operators. These are the upstream operators, packaged with the necessary dependencies to make them work out of the box in libre.sh.

Finally, we want to build a nice UI to let end user self serve these great FLOSS tools. The objective would be to have an alpha version of this UI by beginning of 2021.

This is the general idea of the libre.sh kubernetes distribution. This is early and work in progress, feel free to get in touch to discuss about the different points.

## Who uses it

It is currently used and developed at https://indie.host in production since more than a year.
If you use it or plan to use it, feel free to add your organization here!

## Who is it for

If you need to deploy just a couple of Nextcloud instances, then this is probably not for you.

If you want to selfhost on a single host, it is probably not mature enough for you to have a seemless experience (but hopefully we'll get there).

If you want to discover kubernetes, and you are a free software enthousiast, you are at the right place.

If you need to build an infrastructure to host free software that would need to scale, it is also for you.

If you need high availability and you are not allergic to containers, even for one Nextcloud instance, it could be for you.

If you need to host hundreds of free software instances, like we do, it is definitely for you!
