# compose-lighttpd

Docker container and compose file for serving static content using lighttpd


## Executing

    docker run --name "my-lighttpd" -P -v $(pwd)/content:/var/www allmende/lighttpd

Find your container:

    docker ps | grep "my-lighttpd"
    CONTAINER ID        IMAGE                           COMMAND                CREATED             STATUS              PORTS                   NAMES
    ba00b5c238fc        allmende/lighttpd:latest   "lighttpd -D -f /etc   1 second ago        Up 1 second         0.0.0.0:49153->80/tcp   my-lighttpd

Check if it works:

    curl localhost:49153
    This is your content.


## Building The Image Yourself (optional)

    docker build -t allmende/lighttpd .

The image is conveniently small at **below 7 MB** thanks to [alpine](http://gliderlabs.viewdocs.io/docker-alpine):

    docker images | grep lighttpd
    allmende/lighttpd   latest              b2e7a8364baa        1 second ago      6.451 MB

## Using with Docker Compose

You can use the image with the Docker Compose file provided.

In case you are using jwilder/nginx as a frontend proxy, copy `frontend.env.example` to `frontend.env` and fill it with your details.

In case you are using træfik, uncomment and configure the labels appropriately.

Then place files you seek to serve into `content/` and fire it up!
