# compose-matrix

This composition aligns Matrix' `synapse` and `riot` with `postgres` and `coturn`.

## Dependencies

- Docker
- Docker Compose

## Opinionated environment

- libre.sh
- seperate data and database ZFS datasets
- Træfik TLS termination
- Turn configuration
- Weave network

## Installation

```
git clone https://lab.libreho.st/ecobytes/compose/compose-matrix.git
cd compose-matrix
docker-compose pull
```

Please refer to the official Docker installation instructions, to proceed with configuring your homeserver.

- https://github.com/matrix-org/synapse/tree/master/docker
- https://github.com/matrix-org/synapse/blob/master/INSTALL.md#setting-up-synapse
- https://github.com/matrix-org/synapse/blob/bee1982d177234d92d06c352a303653eee9c1e98/docs/sample_config.yaml

An exemplary configuration is provided for

- `files/homeserver.yaml.example`
- `riot/config.json.example`
- `turn/turnserver.conf.example`

from which you can adapt your settings. Please make sure to replace the `SECRET` placeholders accordingly when not generating the configuration file automatically.

```
docker-compose up
```

If that works according to your wishes, one may also comment the `logging` sections to verify, you can enable and start your libre.sh application.

```
libre enable
libre start
```

Also see:

- https://github.com/spantaleev/matrix-docker-ansible-deploy

## Maintenance

Update tagged application versions

```
sed -i 's/riot-web:v1.5.3/riot-web:v1.5.6/' docker-compose.yaml
sed -i 's/synapse:v1.5.1/synapse:v1.7.0/' docker-compose.yaml
docker-compose pull synapse riot
```

Recycle chosen containers

    docker-compose stop synapse riot && docker-compose rm -f synapse riot && docker-compose up -d


Recycle all containers

```
docker-compose stop
docker-compose rm -f
docker-compose up -d
```

or

    libre restart

## License

2019 Ecobytes e.V., Jon Richter, Public Domain.
