#!/bin/bash

#Current version of libre.sh to be installed 
LIBRE_VERSION=release/1.2
# System env vars  : can be overrided by a values.env file next to this install file


### CONFIG : Specify you template repo ROOT without training slash (Optional) or comment if you want to supply full url for apps

APP_REPO_URL="lab.libreho.st/libre.sh/compose"

## domain handling 

### CONFIG : change to your domain vendor ( namecheap, ovh , scaleway, )
DOMAIN_SERVER=namecheap

###  Namecheap specific
NAMECHEAP_URL="namecheap.com"
NAMECHEAP_API_USER="pierreo"
NAMECHEAP_API_KEY=

### ovh specific (WIP) 
OVH_URL="eu.api.ovh.com"
OVH_API_USER=""
OVH_API_KEY=


### Scaleway specific (WIP) 
SCALEWAY_URL=""
SCALEWAY_API_USER=""
SCALEWAY_API_KEY=


### TODO :  change your settings 
IP="curl -s http://icanhazip.com/"
FirstName="Pierre"
LastName="Ozoux"
Address=""
PostalCode=""
Country="Portugal"
Phone="+351.967184553"
EmailAddress="pierre@ozoux.net"
City="Lisbon"
CountryCode="PT"
## Backup
BACKUP_DESTINATION=root@xxxxx:port

### CONFIG  : Change your mail settings.
## SMTP
MAIL_USER=
MAIL_PASS=
MAIL_HOST=mail.indie.host
MAIL_PORT=587

# Default admin emails for apps

ADMIN_EMAIL=support@ekimia.fr

### TODO : source a setting file is present to override defaults

echo "-------- Welcome to libre.sh $LIBRE_VERSION installer"

echo "----  sourcing local values.env file if present"

source values.env


# STEP add kernel parameter

# STEP Define environnement

echo "-------- setting up system variables"

echo "APP_REPO_URL=${APP_REPO_URL}" >> /etc/environment

echo "LIBRE_VERSION=${LIBRE_VERSION}" >> /etc/environment

echo "MAIL_USER=${MAIL_USER}" >> /etc/environment

echo "MAIL_PASS=${MAIL_PASS}" >> /etc/environment

echo "MAIL_HOST=${MAIL_HOST}" >> /etc/environment

echo "MAIL_PORT=${MAIL_PORT}" >> /etc/environment

echo "ADMIN_EMAIL=${ADMIN_EMAIL}" >> /etc/environment


# STEP Install Docker 

echo "-------- Install latest docker "
# TODO : Fix a version for docker  ? 


curl -fsSL https://get.docker.com -o get-docker.sh
sh get-docker.sh 


# STEP "install docker-compose" 
echo "-------- Install latest docker-compose "

# TODO : Fix a version for docker compose ? 

mkdir -p /opt/bin &&\
dockerComposeVersion=$(curl -s https://api.github.com/repos/docker/compose/releases/latest|grep tag_name|cut -d'"' -f4) &&\
curl -L https://github.com/docker/compose/releases/download/$dockerComposeVersion/docker-compose-`uname -s`-`uname -m` > /opt/bin/docker-compose &&\
chmod +x /opt/bin/docker-compose



# STEP install Libre.sh

echo "-------- installing libre.sh" 

git clone https://lab.libreho.st/libre.sh/compose.libre.sh -b $LIBRE_VERSION /libre.sh 
mkdir -p /{data,system}
mkdir -p /data/trash 
cp /libre.sh/unit-files/* /etc/systemd/system && systemctl daemon-reload 
systemctl enable web-net.service 
systemctl start web-net.service 
mkdir -p /opt/bin 
cp /libre.sh/utils/* /opt/bin/


# STEP add /opt/bin path


echo "-------- updating PATH" 
cat > /etc/profile.d/libre.sh <<EOF
export PATH=$PATH:/opt/bin
EOF
chmod 644 /etc/profile.d/libre.sh
bash /etc/profile.d/libre.sh

