<?php

    namespace IdnoPlugins\Comments\Pages {

        use Idno\Common\Entity;
        use Idno\Common\Page;
        use Idno\Core\Webmention;
        use Idno\Core\Webservice;

        class Post extends Page
        {

            function postContent()
            {

                $body      = strip_tags($this->getInput('body'));
                $name      = strip_tags($this->getInput('name'));
                $url       = trim($this->getInput('url'));
                $validator = $this->getInput('validator');

                if (!empty($body) && !empty($name) && !empty($url) && !empty($validator)) {
                    if ($object = Entity::getByUUID($validator)) {
                        if ($url = Webservice::sanitizeURL($url)) {
                            if ($content = Webservice::get($url)) {
                                if ($content['response'] == '200') {
                                    if (!($icon = Webmention::getIconFromWebsiteContent($content['content'], $url))) {
                                        $bn = hexdec(substr(md5($url), 0, 15));
                                        $number = 1 + ($bn % 5);
                                        $icon = \Idno\Core\site()->config()->url . 'gfx/users/default-'. str_pad($number, 2, '0', STR_PAD_LEFT) .'.png';
                                    }
                                    $object->addAnnotation('reply', $name, $url, $icon, $body);
                                }
                            }
                        }
                        $this->forward($object->getURL());

                    }
                }

            }

        }

    }