#!/bin/sh
set -eu

echo "New nextcloud instance"
if [ -n "${NEXTCLOUD_ADMIN_USER+x}" ] && [ -n "${NEXTCLOUD_ADMIN_PASSWORD+x}" ]; then
    echo "starting nexcloud installation"
    max_retries=10
    try=0

    until sh -c "php /usr/src/nextcloud/occ maintenance:install -n --admin-user $NEXTCLOUD_ADMIN_USER --admin-pass $NEXTCLOUD_ADMIN_PASSWORD" || [ "$try" -gt "$max_retries" ]
        do
            echo "retrying install..."
            try=$((try+1))
            sleep 3s
        done

    if [ "$try" -gt "$max_retries" ]; then
        echo "installing of nextcloud failed!"
        exit 1
    fi
else
    echo "running web-based installer on first connect!"
fi

# Fix Nc...
sh -c "php /usr/src/nextcloud/occ db:convert-filecache-bigint -n"
sh -c "php /usr/src/nextcloud/occ db:add-missing-indices"
sh -c "php /usr/src/nextcloud/occ config:app:set core backgroundjobs_mode --value cron"

# DISABLE_APPS=firstrunwizard,contacts
if [ -n "${DISABLE_APPS+x}" ]; then
    sh -c "php /usr/src/nextcloud/occ app:disable $(echo $DISABLE_APPS | sed "s/,/ /g")"
fi
/usr/local/bin/php occ app:disable dashboard survey_client user_status weather_status bruteforcesettings nextcloud_announcements password_policy
/usr/local/bin/php /usr/src/nextcloud/occ app:enable files_versions_s3

# ENABLE_APPS=user_saml,apporder
if [ -n "${ENABLE_APPS+x}" ]; then
    sh -c "php /usr/src/nextcloud/occ app:enable $(echo $ENABLE_APPS | sed "s/,/ /g")"
fi

if [ -n "${ONLYOFFICE_JWT_SECRET+x}" ]; then
    sh -c "php /usr/src/nextcloud/occ app:enable onlyoffice"
    sh -c "php /usr/src/nextcloud/occ config:app:set onlyoffice jwt_secret --value ${ONLYOFFICE_JWT_SECRET}"
    sh -c "php /usr/src/nextcloud/occ config:app:set onlyoffice DocumentServerUrl --value ${ONLYOFFICE_SERVER}"
    sh -c "php /usr/src/nextcloud/occ config:app:set onlyoffice sameTab --value true"
    sh -c "php /usr/src/nextcloud/occ config:app:set onlyoffice versionHistory --value true"
    sh -c "php /usr/src/nextcloud/occ config:app:set onlyoffice customizationForcesave --value true"
fi

if [ -n "${PRIVACY_DATA_LOCATION+x}" ]; then
    sh -c "php /usr/src/nextcloud/occ config:app:set privacy readableLocation --value ${PRIVACY_DATA_LOCATION}"
fi

if [ -n "${SAML_IDP_URL+x}" ] && [ -n "${SAML_REALM+x}" ]; then
    php occ saml:config:set --general-idp0_display_name=$SAML_DISPLAY_NAME \
    --idp-entityId=${SAML_IDP_URL}/auth/realms/${SAML_REALM} \
    --general-uid_mapping=username \
    --idp-entityId=${SAML_IDP_URL}/auth/realms/${SAML_REALM} \
    --idp-singleLogoutService.url=${SAML_IDP_URL}/auth/realms/${SAML_REALM}/protocol/saml \
    --idp-singleSignOnService.url=${SAML_IDP_URL}/auth/realms/${SAML_REALM}/protocol/saml \
    --idp-x509cert="${SAML_IDP_CERT}" \
    --security-authnRequestsSigned=1 \
    --security-logoutRequestSigned=1 \
    --security-logoutResponseSigned=1 \
    --security-wantAssertionsSigned=1 \
    --security-wantMessagesSigned=1 \
    --sp-x509cert="${SAML_CERT}" \
    --sp-privateKey="${SAML_KEY}" \
    --saml-attribute-mapping-displayName_mapping=username \
    --saml-attribute-mapping-email_mapping=email \
    --saml-attribute-mapping-group_mapping=groups \
    1
    php occ config:app:set user_saml type --value="saml"
    php occ config:app:set user_saml use_saml_auth_for_desktop --value="1"
fi

/usr/local/bin/php occ config:app:set theming url --value="https://indiehosters.net"
/usr/local/bin/php occ config:app:set theming color --value="#0DB4C7"
/usr/local/bin/php occ config:app:set theming name --value="Nuage Liiibre"
/usr/local/bin/php occ config:app:set theming slogan --value="Fabriquer l'avenir et rester libres."
/usr/local/bin/php /usr/src/nextcloud/occ config:app:set files default_quota --value="10 GB"
