import argparse,requests,json,tarfile,os

def get_manifest(path):
    with open(path, "r") as file:
        return json.load(file)

def save_manifest(path, manifest):
    with open(path, "w") as file:
        text = json.dumps(manifest, sort_keys=True, indent=2)
        file.write(text)

def update_nc(manifest, major=""):
    if not major:
        major = manifest["version"][:2]
    response = requests.get('https://api.github.com/repos/nextcloud/server/releases')
    body = response.json()
    for version in body:
        if (not version["draft"] and not version["prerelease"] and version["name"].startswith("v"+major)):
            manifest["version"] = version["name"][1:]
            break

def update_apps(manifest):
    response = requests.get(f"https://apps.nextcloud.com/api/v1/platform/{manifest['version']}/apps.json")
    catalog=response.json()
    for app in manifest["apps"]:
        for catalog_app in catalog:
            if catalog_app["id"] == app:
                for release in catalog_app["releases"]:
                    if release["isNightly"]:
                        continue
                    manifest["apps"][app] = release["download"]
                    break
                break

def download_apps(manifest):
    for app,url in manifest["apps"].items():
        print(f"downloading {app}")
        os.system(f'curl -Ls "{url}" | tar xz')

if __name__ == '__main__':
    parser = argparse.ArgumentParser(description='Helper script to manage Nextcloud apps.')
    parser.add_argument("--manifest", default="nextcloud.json", help="path of the manifest")
    parser.add_argument("--version", help="nextcloud major version")
    parser.add_argument("action", choices=["update","download"])
    args = parser.parse_args()

    manifest = get_manifest(args.manifest)

    if args.action == "update":
        update_nc(manifest, args.version)
        update_apps(manifest)
        save_manifest(args.manifest, manifest)

    if args.action == "download":
        download_apps(manifest)
