#!/bin/sh
set -eu

/usr/local/bin/php occ app:enable liiibre 

if [ -z "${CHAT_URL:=}" ]; then
    /usr/local/bin/php occ config:app:delete liiibre chat_url
else
    /usr/local/bin/php occ config:app:set liiibre chat_url --value "${CHAT_URL}"
fi

if [ -z "${VISIO_URL:=}" ]; then
    /usr/local/bin/php occ config:app:delete liiibre visio_url
else
    /usr/local/bin/php occ config:app:set liiibre visio_url --value "${VISIO_URL}"
fi

if [ -z "${SAML_IDP_URL:=}" ]; then
    /usr/local/bin/php occ config:app:delete liiibre sso_account_url
    /usr/local/bin/php occ config:app:delete liiibre sso_admin_url
else
    /usr/local/bin/php occ config:app:set liiibre sso_account_url --value "${SAML_IDP_URL}/auth/realms/${SAML_REALM}/account"
    /usr/local/bin/php occ config:app:set liiibre sso_admin_url --value "${SAML_IDP_URL}/auth/admin/${SAML_REALM}/console"
fi

php occ config:app:set mail app.mail.smtp.timeout --value=10
