#!/bin/bash

# List instances where indie_external is not enabled
# If an app is enabled it prints the version, if not, it doesn't

for ns in `kubectl get ns --no-headers -o custom-columns=":metadata.name"`; do # Loop all Ns
  po=`kubectl -n $ns get po  -l app.kubernetes.io/name=nextcloud,app.kubernetes.io/component=app --no-headers -o custom-columns=":metadata.name" | head -n1` # Get the first po
  if [ ! -z "$po" ]; then # if there is Nc in this Ns
    if ! kubectl -n $ns exec $po -- php /usr/src/nextcloud/occ config:app:get user_saml saml-attribute-mapping-group_mapping | grep -q "groups"; then # check that our app is not activated
      echo $ns # Print ns if Nc installed and app not activated
    fi
  fi
done

