function create_bucket() {
  export AWS_SECRET_ACCESS_KEY=`openssl rand -base64 32`
  mc admin user add ${STORAGE_CLASS} ${AWS_ACCESS_KEY_ID} ${AWS_SECRET_ACCESS_KEY}
  kubectl -n ${NS} create secret generic ${SECRET_NAME} --from-literal=AWS_ACCESS_KEY_ID=${AWS_ACCESS_KEY_ID} --from-literal=AWS_SECRET_ACCESS_KEY=${AWS_SECRET_ACCESS_KEY}
  mc mb ${STORAGE_CLASS}/${AWS_ACCESS_KEY_ID}
  mc admin policy set ${STORAGE_CLASS} username-rw user=${AWS_ACCESS_KEY_ID}
}

function create_ns() {
  mkdir -p /root/domains/${NS}
  kubectl create ns ${NS} || true
  kubectl -n ${NS} apply -f /root/domains/common/networkpolicies.yml
}

function pg_zero_lag() {
  cat /tmp/patronictl_list |tail -n2| cut -d$'\t' -f 7 | grep -q 0
}

function pg_two_running() {
  cat /tmp/patronictl_list |tail -n2| cut -d$'\t' -f 5 | grep running | wc -l | grep -q 2
}

function pg_consistent_tl() {
  TL_ONE=`cat /tmp/patronictl_list |tail -n2 | head -n1 | cut -d$'\t' -f 6`
  TL_TWO=`cat /tmp/patronictl_list |tail -n1 | cut -d$'\t' -f 6`
  test "$TL_ONE" = "$TL_TWO"
}

function pg_current_tl() {
  if pg_consistent_tl; then
    export PG_CURRENT_TL=`cat /tmp/patronictl_list |tail -n1 | cut -d$'\t' -f 6`
  fi
}

function pg_different_tl() {
  if pg_consistent_tl; then
    pg_current_tl 
    test "$PG_CURRENT_TL" != "$PG_PREVIOUS_TL"
  fi
}

function pg_one_leader() {
  cat /tmp/patronictl_list |tail -n2| cut -d$'\t' -f 4 | grep -q Leader
}

function pg_save_patronictl_list_to_temp_file() {
  set -o pipefail
  until kubectl -n ${NS} exec -it ${PG_CLUSTER}-0 -- patronictl list -f tsv 1> /tmp/patronictl_list 2> /dev/null
  do
    echo -n "."
    sleep 2
  done
}


function pg_healthy() {
  test pg_zero_lag && pg_two_running && pg_consistent_tl && pg_one_leader
}

function pg_ensure_rolling_update_is_done() {
  echo -n "Waiting pg to roll"
  pg_save_patronictl_list_to_temp_file
  pg_current_tl
  export PG_PREVIOUS_TL=$PG_CURRENT_TL
  until pg_healthy && pg_different_tl
  do
    pg_save_patronictl_list_to_temp_file
    echo -n "."
    sleep 2
  done
  echo "Rolling is done and successful!"
  kubectl -n ${NS} exec -it ${PG_CLUSTER}-0 -- patronictl list
  kubectl -n ${NS} logs ${PG_CLUSTER}-0 --tail=2
  kubectl -n ${NS} logs ${PG_CLUSTER}-1 --tail=2
}

function pg_set_archive_mode_and_wait() {
  pg_save_patronictl_list_to_temp_file
  until pg_healthy 
  do
    echo -n "Waiting PG to be healthy"
    pg_save_patronictl_list_to_temp_file
    echo -n "."
    sleep 2
  done
  if kubectl -n ${NS} patch  --type merge pg ${PG_CLUSTER}  --patch '{"spec":{"postgresql":{"parameters":{"archive_mode":"'${ARCHIVE_MODE}'"}}}}' | grep -q "no change"
  then
    echo "PG not patched, going to next step."
  else
    pg_ensure_rolling_update_is_done
  fi 
}
