#!/bin/bash -eu

cd /root/domains

for nuage in `kubectl get ing -l app.kubernetes.io/name=nextcloud -A --no-headers -o custom-columns=":metadata.name" | sed s/-web//g | grep -v "beta\|test-meteo"`; do
  export NS=`echo $nuage | cut -d"-" -f2-`
  export SUBDOMAIN=`echo $nuage | cut -d"-" -f1`
  echo Upating $SUBDOMAIN $NS ...
  export APP=${SUBDOMAIN}-${NS}
  cd $NS/$SUBDOMAIN
  libre update --batch
  cd -
done
