#!/bin/bash -eu

for deploy in `kubectl get  deploy -l app.kubernetes.io/component=app,app.kubernetes.io/name=nextcloud -A --no-headers -o custom-columns=":metadata.name"`; do
  export NS=`echo $deploy | sed 's/-app//g' | cut -d'-' -f2-`
  echo -n .
  if ! kubectl -n ${NS} exec -it deploy/$deploy -- php occ app:list | grep -q files_pdfviewer:; then
    echo app disabled $NS
  fi
  if kubectl -n ${NS} exec deploy/$deploy -- php occ config:app:get onlyoffice defFormats 2>&1 | grep -q pdf; then
    if kubectl -n ${NS} exec deploy/$deploy -- php occ config:app:get onlyoffice defFormats 2>&1 | jq '.pdf' | grep -q true; then
      echo oo $NS
    fi
  fi
done
