#!/bin/bash -eu

for rc in `kubectl get ing -l app.kubernetes.io/name=Rocketchat -A --no-headers -o custom-columns=":metadata.name" | sed s/-app//g |grep -v "redirect\|beta\|test"`; do
  export NS=`echo $rc | cut -d"-" -f2-`
  export SUBDOMAIN=`echo $rc | cut -d"-" -f1`
  export BucketURL=`kubectl -n ${NS} get cm ${SUBDOMAIN}-${NS}-config -o json | jq -r ".data.OVERWRITE_SETTING_FileUpload_S3_BucketURL"`
  if [ "$BucketURL" = "https://s3.standard.indie.host" ]; then
    echo Syncing $rc ...
    /root/domains/common/scripts/change_stockage_rc_second_sync.sh
  fi
done
