#!/bin/bash -eu

for host in `kubectl get  ing -l app.kubernetes.io/name=nextcloud -A --no-headers -o custom-columns=":spec.rules[0].host" | grep -v alpha`;do
  export folder=`echo $host| cut -d'.' -f2- | rev | sed 's/\./-/' | rev`
  echo $folder
  export NS=`echo $host| cut -d'.' -f2- | sed 's/\./-/g'`
  echo $NS
  export sub=`echo $host| cut -d'.' -f1`
  echo $sub

  cd /root/domains/$folder/$sub
  kubectl -n $NS delete job dump || true
  libre apply /root/domains/common/nextcloud/other-manifests/dump.yml;
done
