#!/bin/bash

for NS in `kubectl get po -A | grep Error | cut -d" " -f1 | sort | uniq`; do
    ## Jobs
    kubectl -n $NS  get job  --field-selector=status.successful=1
    kubectl -n $NS  get job  --field-selector=status.successful=0
    read -p "Press enter to delete failed jobs"
    kubectl -n $NS  delete job  --field-selector=status.successful=0

    ## Pods
    kubectl -n $NS get po --field-selector 'status.phase=Succeeded'
    kubectl -n $NS get po --field-selector 'status.phase=Failed'
    read -p "Press enter to delete failed pods"
    kubectl -n $NS delete po --field-selector 'status.phase=Failed'
done
