function create_bucket() {
  export AWS_SECRET_ACCESS_KEY=`openssl rand -base64 32`
  mc admin user add ${STORAGE_CLASS} ${AWS_ACCESS_KEY_ID} ${AWS_SECRET_ACCESS_KEY}
  kubectl -n ${NS} create secret generic ${SECRET_NAME} --from-literal=AWS_ACCESS_KEY_ID=${AWS_ACCESS_KEY_ID} --from-literal=AWS_SECRET_ACCESS_KEY=${AWS_SECRET_ACCESS_KEY}
  mc mb ${STORAGE_CLASS}/${AWS_ACCESS_KEY_ID}
  mc admin policy set ${STORAGE_CLASS} username-rw user=${AWS_ACCESS_KEY_ID}
}

function create_bucket_for_live() {
  export AWS_SECRET_ACCESS_KEY=`openssl rand -base64 32`
  mc admin user add ${STORAGE_CLASS} ${AWS_ACCESS_KEY_ID} ${AWS_SECRET_ACCESS_KEY}
  kubectl -n ${NS} create secret generic ${SECRET_NAME} --from-literal=AWS_ACCESS_KEY_ID=${AWS_ACCESS_KEY_ID} --from-literal=AWS_SECRET_ACCESS_KEY=${AWS_SECRET_ACCESS_KEY}
  mc mb ${STORAGE_CLASS}/${AWS_ACCESS_KEY_ID}
  mc admin policy set ${STORAGE_CLASS} username-rw user=${AWS_ACCESS_KEY_ID}
  mc policy set download ${STORAGE_CLASS}/${AWS_ACCESS_KEY_ID}
}

function create_bucket_for_forum() {
  create_bucket
  mc policy set download ${STORAGE_CLASS}/${AWS_ACCESS_KEY_ID}
}

function create_buckets_for_gitlab() {
  export AWS_SECRET_ACCESS_KEY=`openssl rand -base64 32`
  mc admin user add ${STORAGE_CLASS} ${FQDN} ${AWS_SECRET_ACCESS_KEY}
  mc admin policy set ${STORAGE_CLASS} username-rw-gitlab user=${FQDN}
  mc mb ${STORAGE_CLASS}/${FQDN}-artifacts
  mc mb ${STORAGE_CLASS}/${FQDN}-lfs
  mc mb ${STORAGE_CLASS}/${FQDN}-packages
  mc mb ${STORAGE_CLASS}/${FQDN}-uploads
}

function create_ns() {
  mkdir -p /root/domains/${FOLDER}
  kubectl create ns ${NS} || true
  kubectl label ns $NS libre.sh/scope=user
  kubectl label ns/$NS name=$NS
  cat "/root/domains/common/networkpolicies.yml" | envsubst '$NS' | kubectl -n ${NS} apply -f -
}

function pg_zero_lag() {
  cat /tmp/patronictl_list |tail -n2| cut -d$'\t' -f 7 | grep -q 0
}

function pg_two_running() {
  cat /tmp/patronictl_list |tail -n2| cut -d$'\t' -f 5 | grep running | wc -l | grep -q 2
}

function pg_consistent_tl() {
  TL_ONE=`cat /tmp/patronictl_list |tail -n2 | head -n1 | cut -d$'\t' -f 6`
  TL_TWO=`cat /tmp/patronictl_list |tail -n1 | cut -d$'\t' -f 6`
  test "$TL_ONE" = "$TL_TWO"
}

function pg_current_tl() {
  if pg_consistent_tl; then
    export PG_CURRENT_TL=`cat /tmp/patronictl_list |tail -n1 | cut -d$'\t' -f 6`
  fi
}

function pg_different_tl() {
  if pg_consistent_tl; then
    pg_current_tl 
    test "$PG_CURRENT_TL" != "$PG_PREVIOUS_TL"
  fi
}

function pg_one_leader() {
  cat /tmp/patronictl_list |tail -n2| cut -d$'\t' -f 4 | grep -q Leader
}

function pg_save_patronictl_list_to_temp_file() {
  set -o pipefail
  until kubectl -n ${NS} exec -it ${PG_CLUSTER}-0 -- patronictl list -f tsv 1> /tmp/patronictl_list 2> /dev/null
  do
    echo -n "."
    sleep 2
  done
}


function pg_healthy() {
  test pg_zero_lag && pg_two_running && pg_consistent_tl && pg_one_leader
}

function pg_ensure_rolling_update_is_done() {
  echo -n "Waiting pg to roll"
  pg_save_patronictl_list_to_temp_file
  pg_current_tl
  export PG_PREVIOUS_TL=$PG_CURRENT_TL
  until pg_healthy && pg_different_tl
  do
    pg_save_patronictl_list_to_temp_file
    echo -n "."
    sleep 2
  done
  echo "Rolling is done and successful!"
  kubectl -n ${NS} exec -it ${PG_CLUSTER}-0 -- patronictl list
  kubectl -n ${NS} logs ${PG_CLUSTER}-0 --tail=2
  kubectl -n ${NS} logs ${PG_CLUSTER}-1 --tail=2
}

function pg_set_archive_mode_and_wait() {
  pg_save_patronictl_list_to_temp_file
  until pg_healthy 
  do
    echo -n "Waiting PG to be healthy"
    pg_save_patronictl_list_to_temp_file
    echo -n "."
    sleep 2
  done
  if kubectl -n ${NS} patch  --type merge pg ${PG_CLUSTER}  --patch '{"spec":{"postgresql":{"parameters":{"archive_mode":"'${ARCHIVE_MODE}'"}}}}' | grep -q "no change"
  then
    echo "PG not patched, going to next step."
  else
    pg_ensure_rolling_update_is_done
  fi 
}

function create_emails() {
  noreply_email_password=$(cat /dev/urandom | tr -dc 'a-zA-Z0-9' | fold -w 18 | head -n 1)
  noreply_email="${NS}@liiib.re"
  forum_email_password=$(cat /dev/urandom | tr -dc 'a-zA-Z0-9' | fold -w 18 | head -n 1)
  forum_email="forum-${NS}@liiib.re"
  chat_email_password=$(cat /dev/urandom | tr -dc 'a-zA-Z0-9' | fold -w 18 | head -n 1)
  chat_email="${CHAT_SUBDOMAIN}-${NS}@liiib.re"

  source /etc/env

  mail_username=contact@indie.host
  mail_hostname=mail.indie.host

  noreply_local_part=`echo $noreply_email | cut -d@ -f1`
  forum_local_part=`echo $forum_email | cut -d@ -f1`
  chat_local_part=`echo $chat_email | cut -d@ -f1`
  email_domain=`echo $noreply_email | cut -d@ -f2`

  curl --data "username=${mail_username}&password=${mail_password}&login=Log+In&rememberme=0" -c /tmp/cookie.txt https://${mail_hostname}/auth/login
  domain_id=`curl -b /tmp/cookie.txt https://${mail_hostname}/domain | grep $email_domain | grep purge-domain | grep -o 'purge-domain-[0-9]*' | grep -o '[0-9]*'`

  curl --data "local_part=${noreply_local_part}&domain=${domain_id}&password=${noreply_email_password}" -b /tmp/cookie.txt https://${mail_hostname}/mailbox/add
  curl --data "local_part=${forum_local_part}&domain=${domain_id}&password=${forum_email_password}" -b /tmp/cookie.txt https://${mail_hostname}/mailbox/add
  curl --data "local_part=${chat_local_part}&domain=${domain_id}&password=${chat_email_password}" -b /tmp/cookie.txt https://${mail_hostname}/mailbox/add

  rm /tmp/cookie.txt

  kubectl -n ${NS} create secret generic ${NS}-smtp --from-literal=host=mail.indie.host --from-literal=port=587 --from-literal=from_email=${noreply_email} --from-literal=username=${noreply_email} --from-literal=password=${noreply_email_password} --from-literal=mail_from_address=${noreply_local_part}
  kubectl -n ${NS} create secret generic forum-${NS}-smtp --from-literal=host=mail.indie.host --from-literal=port=587 --from-literal=from_email=${forum_email} --from-literal=username=${forum_email} --from-literal=password=${forum_email_password} --from-literal=mail_from_address=${forum_local_part}
  kubectl -n ${NS} create secret generic ${CHAT_SUBDOMAIN}-${NS}-smtp --from-literal=host=mail.indie.host --from-literal=port=587 --from-literal=from_email=${chat_email} --from-literal=username=${chat_email} --from-literal=password=${chat_email_password} --from-literal=mail_from_address=${chat_local_part}
}

