#!/bin/bash -eu

for hedgedoc in `kubectl get ing -l app.kubernetes.io/name=hedgedoc -A --no-headers -o custom-columns=":metadata.name" | sed s/-app//g |grep -v redirect`; do
  export NS=`echo $hedgedoc | cut -d"-" -f2-`
  export SUBDOMAIN=`echo $hedgedoc | cut -d"-" -f1`
  export CMD_MINIO_ENDPOINT=`kubectl -n ${NS} get cm ${SUBDOMAIN}-${NS}-config -o json | jq -r ".data.CMD_MINIO_ENDPOINT"`
  if [ "$CMD_MINIO_ENDPOINT" = "s3.standard.indie.host" ]; then
    if ! kubectl get secret -n ${NS} ${hedgedoc}-s3-new | grep -q new; then
      echo Syncing $hedgedoc ...
      /root/domains/common/scripts/change_stockage_hedgedoc_first_sync.sh
    fi
  fi
done
