#!/bin/bash -eu

#export NS=liiib-re
#export SUBDOMAIN=nuage

export APP=${SUBDOMAIN}-${NS}

kubectl -n ${NS} scale --replicas=0 deployment/${APP}-app
cd ~/domains/${NS}/${SUBDOMAIN}
kubectl -n ${NS} delete job/${SUBDOMAIN}-${NS}-sync-buckets
libre apply ~/domains/common/nextcloud/other-manifests/sync-job.yml
kubectl -n ${NS} wait --for=condition=complete --timeout=-1s job/${SUBDOMAIN}-${NS}-sync-buckets

kubectl -n ${NS} get configmap ${APP}-config --export -o json 2> /dev/null | jq '.data["OVERWRITE_SETTING_FileUpload_S3_BucketURL"]="hot-objects.liiib.re"'  | kubectl -n ${NS} apply -f -

kubectl -n ${NS} delete secret ${APP}-s3
kubectl -n ${NS} get secret ${APP}-s3-new --export -o yaml 2> /dev/null | sed "s/${APP}-s3-new/${APP}-s3/g" | kubectl -n ${NS} apply -f -

kubectl -n ${NS} scale --replicas=2 deployment/${APP}-app
