#!/bin/bash -eu

source /root/domains/common/scripts/functions.sh

#export NS=liiib-re
#export SUBDOMAIN=nuage
export APP=${SUBDOMAIN}-${NS}
export S3_ENDPOINT=https://hot-objects.liiib.re
export STORAGE_CLASS=hot

# Create new hot bucket
export AWS_ACCESS_KEY_ID=${APP}
export SECRET_NAME=${APP}-s3-new
create_bucket
#mc version enable ${STORAGE_CLASS}/${AWS_ACCESS_KEY_ID}

kubectl -n liiib-re get secret ro-s3 --export -o yaml 2> /dev/null | kubectl -n ${NS} apply -f -
kubectl -n ${NS} get secret ${APP}-s3 --export -o yaml 2> /dev/null | sed "s/${APP}-s3/${APP}-backup/g" | kubectl -n ${NS} apply -f -

cd ~/domains/${NS}/${SUBDOMAIN}
libre apply ~/domains/common/nextcloud/other-manifests/sync-job.yml
