#!/bin/bash -eu

source /root/domains/common/scripts/functions.sh

#export NS=liiib-re
#export SUBDOMAIN=nuage

cd ~/domains/${NS}/${SUBDOMAIN}
libre apply ~/domains/common/nextcloud/other-manifests/sync-job.yml


kubectl -n ${NS} get secret ${APP}-app --export -o json 2> /dev/null | jq --arg value "$(echo -n hot-objects.liiib.re | base64 -w0)" '.data["OBJECTSTORE_S3_HOST"]=$value'  | kubectl -n ${NS} apply -f -


kubectl -n ${NS} scale --replicas=0 deployment/${APP}-app
kubectl -n ${NS} delete secret ${APP}-s3
kubectl -n ${NS} get secret ${APP}-s3-new --export -o yaml 2> /dev/null | sed "s/${APP}-s3-new/${APP}-s3/g" | kubectl -n ${NS} apply -f -

kubectl -n ${NS} scale --replicas=2 deployment/nuage-liiib-re-app
PO=`k -n ${NS} get po  -l app.kubernetes.io/name=nextcloud,app.kubernetes.io/component=app --no-headers -o custom-columns=":metadata.name" | head -n1` # Get the first po
kubectl -n ${NS} exec $PO -- php occ app:enable files_versions_s3
