#!/bin/bash

for deploy in `kubectl get  deploy -l app.kubernetes.io/component=app,app.kubernetes.io/name=nextcloud -A --no-headers -o custom-columns=":metadata.name"`; do
  export NS=`echo $deploy | sed 's/-app//g' | cut -d'-' -f2-`
  # echo "${NS}"
  if kubectl -n ${NS} exec -it deploy/$deploy -c app -- php occ app:list --output=json | jq ".enabled" | grep -q "\"external\"";then
    if kubectl -n ${NS} exec -it deploy/$deploy -c app -- php occ config:list | grep -q "\"external"; then
      if kubectl -n ${NS} exec -it deploy/$deploy -c app -- php occ config:app:get external sites | grep -q "Quota"; then
        echo "Quota configured $NS"
      fi
    fi
  fi
done
