#!/bin/bash -eux

for deploy in `kubectl get  deploy -l app.kubernetes.io/component=app,app.kubernetes.io/name=nextcloud -A --no-headers -o custom-columns=":metadata.name" | grep -v beta | grep -v nuage-ca | grep -v test`; do
  export NS=`echo $deploy | sed 's/-app//g' | cut -d'-' -f2-`
  export SUBDOMAIN=`echo $deploy | sed 's/-app//g' | cut -d'-' -f1`
  cd /root/domains/${NS}/${SUBDOMAIN}
  kubectl -n ${NS} delete cj ${SUBDOMAIN}-${NS}-cron
  libre apply /root/domains/common/nextcloud/manifests/cj.yml
done
