#!/bin/bash -eu

for NS_PO in `kubectl get po -A -o wide | grep pw3 | grep pg | awk '{print $1","$2}'`; do
  export NS=`echo $NS_PO | cut -d, -f1`
  export PO=`echo $NS_PO | cut -d, -f2`
  export PG=`echo $PO | rev | cut -d- -f2- | rev`
  echo "Working on NS PO PG: ${NS} ${PO} ${PG}"
  if kubectl exec -it -n ${NS} ${PO} -- df | grep mapper | grep -q "5095040\|5232640"; then
    echo The size is not modified, continuing...
    if kubectl exec -it -n ${NS} ${PO} -- patronictl list | grep -v Leader | grep -q ${PO}; then
      echo Pod is a replica, deleting it...
      kubectl postgres destroy-replicas -n ${NS} ${PG}
    else
      echo Pod is a Master
      #echo Backing up...
      #kubectl postgres backup -n ${NS} ${PG}
      #echo Switching over...
      #kubectl postgres switchover -n ${NS} ${PG}
      echo skipping...
    fi
  else
    echo size not standard aborting this PO $PO
  fi
done
