#!/bin/bash -eu

source /root/domains/common/scripts/functions.sh

for NS in `kubectl get ns --no-headers -o custom-columns=":metadata.name" | grep -v "workshop\|alpha\|beta"`; do
  echo "Working on NS: $NS"

  for PG_CLUSTER in `kubectl -n ${NS} get pg --no-headers -o custom-columns=":metadata.name"`; do
    export PG_CLUSTER=$PG_CLUSTER
    pg_save_patronictl_list_to_temp_file
    if pg_healthy; then
      echo "PG cluster $PG_CLUSTER is ok"
    else
      echo "PG cluster $PG_CLUSTER is ko"
    fi
  done
done
