#!/bin/bash -eu

for nuage in `kubectl get ing -l app.kubernetes.io/name=nextcloud -A --no-headers -o custom-columns=":metadata.name" | sed s/-web//g | head -n 25`; do
  export NS=`echo $nuage | cut -d"-" -f2-`
  export SUBDOMAIN=`echo $nuage | cut -d"-" -f1`
  export OBJECTSTORE_S3_HOST=`kubectl -n ${NS} get secrets ${SUBDOMAIN}-${NS}-app -o json | jq -r ".data.OBJECTSTORE_S3_HOST" | base64 -d`
  if [ "$OBJECTSTORE_S3_HOST" = "s3.standard.indie.host" ]; then
    echo Syncing $nuage ...
    /root/domains/common/scripts/change_stockage_nuage_second_sync.sh
  fi
done
