#!/bin/bash

# List instances where indie_external is not enabled
# If an app is enabled it prints the version, if not, it doesn't

for ns in `k get ns --no-headers -o custom-columns=":metadata.name"`; do # Loop all Ns
  po=`k -n $ns get po  -l app.kubernetes.io/name=nextcloud,app.kubernetes.io/component=app --no-headers -o custom-columns=":metadata.name" | head -n1` # Get the first po
  if [ ! -z "$po" ]; then # if there is Nc in this Ns
    if ! k -n $ns exec $po -- php occ app:list | grep -q "indie_external: 3.9.0"; then # check that our app is not activated
      echo $ns # Print ns if Nc installed and app not activated
    fi
  fi
done