#!/bin/bash -eu

#export NS=liiib-re
#export SUBDOMAIN=pad

source /root/domains/common/scripts/functions.sh

export APP=${SUBDOMAIN}-${NS}
export S3_ENDPOINT=https://hot-objects.liiib.re
export STORAGE_CLASS=hot

# Create new hot bucket
export AWS_ACCESS_KEY_ID=${APP}
export SECRET_NAME=${APP}-s3-new
create_bucket

kubectl -n liiib-re get secret s3-ro --export -o yaml 2> /dev/null | kubectl -n ${NS} apply -f -
kubectl -n ${NS} get secret ${APP}-s3 --export -o yaml 2> /dev/null | sed "s/${APP}-s3/${APP}-backup/g" | kubectl -n ${NS} apply -f -

cd ~/domains/${NS}/${SUBDOMAIN}
libre apply ~/domains/common/nextcloud/other-manifests/sync-job.yml
kubectl -n ${NS} wait --for=condition=complete --timeout=-1s job/${APP}-sync-buckets
