#!/bin/bash -eu

export STORAGE_CLASS=hot
source /root/domains/common/scripts/functions.sh

while read forum; do
  export NS=`echo $forum | cut -d"." -f2- | sed 's/\./-/g'`
  export SUBDOMAIN=`echo $forum | cut -d"." -f1`
  echo $SUBDOMAIN $NS
  export AWS_ACCESS_KEY_ID=${SUBDOMAIN}-${NS}
  export SECRET_NAME=${AWS_ACCESS_KEY_ID}-s3
  create_bucket
  mc version enable ${STORAGE_CLASS}/${AWS_ACCESS_KEY_ID}
  mc policy set download ${STORAGE_CLASS}/${AWS_ACCESS_KEY_ID}
done <~/pierre/forum/buckets_to_create
