package internal

import (
	"fmt"

	"github.com/Nerzal/gocloak/v11"
	libreappsv1alpha1 "libre.sh/controller/apis/apps/v1alpha1"
)

func MutateOIDCClientRepresentation(oidcClient libreappsv1alpha1.OIDCClient, clientRepresentation *gocloak.Client) {
	clientRepresentation.Name = &oidcClient.Name
	clientRepresentation.ClientID = &oidcClient.Spec.ClientID
	clientRepresentation.PublicClient = oidcClient.Spec.Public
	clientRepresentation.Protocol = gocloak.StringP("openid-connect")
	clientRepresentation.BaseURL = &oidcClient.Spec.BaseURL
	clientRepresentation.RedirectURIs = &oidcClient.Spec.RedirectURIs

	protocolMappers := []gocloak.ProtocolMapperRepresentation{}

	for _, protocolMapper := range oidcClient.Spec.ProtocolMappers {
		protocolMapperRepresentation := gocloak.ProtocolMapperRepresentation{
			Name:           &protocolMapper.Name,
			Protocol:       &protocolMapper.Protocol,
			ProtocolMapper: &protocolMapper.ProtocolMapper,
			Config:         &protocolMapper.Config,
		}
		protocolMappers = append(protocolMappers, protocolMapperRepresentation)
	}

	clientRepresentation.ProtocolMappers = &protocolMappers
	fmt.Println(clientRepresentation.ProtocolMappers)
}
