package apps

import (
	"context"
	"fmt"

	"k8s.io/apimachinery/pkg/runtime"
	ctrl "sigs.k8s.io/controller-runtime"
	"sigs.k8s.io/controller-runtime/pkg/client"
	"sigs.k8s.io/controller-runtime/pkg/log"

	"github.com/Nerzal/gocloak/v11"

	appsv1alpha1 "libre.sh/controller/apis/apps/v1alpha1"
)

// RealmReconciler reconciles a Realm object
type RealmReconciler struct {
	client.Client
	Scheme *runtime.Scheme
}

//+kubebuilder:rbac:groups=apps.libre.sh,resources=realms,verbs=get;list;watch;create;update;patch;delete
//+kubebuilder:rbac:groups=apps.libre.sh,resources=realms/status,verbs=get;update;patch
//+kubebuilder:rbac:groups=apps.libre.sh,resources=realms/finalizers,verbs=update

// Reconcile is part of the main kubernetes reconciliation loop which aims to
// move the current state of the cluster closer to the desired state.
// TODO(user): Modify the Reconcile function to compare the state specified by
// the Realm object against the actual cluster state, and then
// perform operations to make the cluster state reflect the state specified by
// the user.
//
// For more details, check Reconcile and its Result here:
// - https://pkg.go.dev/sigs.k8s.io/controller-runtime@v0.12.1/pkg/reconcile
func (r *RealmReconciler) Reconcile(ctx context.Context, req ctrl.Request) (ctrl.Result, error) {
	_ = log.FromContext(ctx)

	var realm appsv1alpha1.Realm
	err := r.Client.Get(ctx, req.NamespacedName, &realm)
	if err != nil {
		return ctrl.Result{}, client.IgnoreNotFound(err)
	}

	fmt.Println(realm)

	keycloakClient := gocloak.NewClient("http://id.test.local")
	token, err := keycloakClient.LoginAdmin(ctx, "admin", "admin", "master")
	if err != nil {
		return ctrl.Result{}, err
	}

	realmRepresentation, err := keycloakClient.GetRealm(ctx, token.AccessToken, realm.Name)
	apiError := err.(*gocloak.APIError)
	if err != nil {
		if apiError.Code == 404 && apiError.Message == "404 Not Found: Realm not found." {
			// Create Realm

		} else {
			return ctrl.Result{}, err
		}
	}

	// TODO update Realm

	/* 	if err != nil {
	   		return ctrl.Result{}, err
	   	}
	*/
	fmt.Println(realmRepresentation)
	return ctrl.Result{}, nil
}

// SetupWithManager sets up the controller with the Manager.
func (r *RealmReconciler) SetupWithManager(mgr ctrl.Manager) error {
	return ctrl.NewControllerManagedBy(mgr).
		For(&appsv1alpha1.Realm{}).
		Complete(r)
}
