package v1alpha1

import (
	"fmt"

	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
)

const ZalandoTeam = "pg"

// PostgresqlSpec defines the desired state of Postgresql
type PostgresqlSpec struct {
	//+optional
	Suspend bool `json:"suspend,omitempty"`
}

// PostgresqlStatus defines the observed state of Postgresql
type PostgresqlStatus struct {
	//+optional
	Conditions []metav1.Condition `json:"conditions,omitempty"`
}

//+kubebuilder:object:root=true
//+kubebuilder:subresource:status
// +kubebuilder:printcolumn:name="Age",type="date",JSONPath=".metadata.creationTimestamp",description=""
// +kubebuilder:printcolumn:name="Ready",type="string",JSONPath=".status.conditions[?(@.type==\"Ready\")].status",description=""
// +kubebuilder:printcolumn:name="Status",type="string",JSONPath=".status.conditions[?(@.type==\"Ready\")].message",description=""

// Postgresql is the Schema for the postgresqls API
type Postgresql struct {
	metav1.TypeMeta   `json:",inline"`
	metav1.ObjectMeta `json:"metadata,omitempty"`

	Spec   PostgresqlSpec   `json:"spec,omitempty"`
	Status PostgresqlStatus `json:"status,omitempty"`
}

//+kubebuilder:object:root=true

// PostgresqlList contains a list of Postgresql
type PostgresqlList struct {
	metav1.TypeMeta `json:",inline"`
	metav1.ListMeta `json:"metadata,omitempty"`
	Items           []Postgresql `json:"items"`
}

func init() {
	SchemeBuilder.Register(&Postgresql{}, &PostgresqlList{})
}

func (o *Postgresql) GetConditions() []metav1.Condition {
	return o.Status.Conditions
}

func (o *Postgresql) SetConditions(conditions []metav1.Condition) {
	o.Status.Conditions = conditions
}

func (postgres *Postgresql) GetZalandoName() string {
	return fmt.Sprintf("%s-%s", ZalandoTeam, postgres.GetName())
}
