#!/bin/bash

ns=libresh-system

kind create cluster --config ./dev/cluster.yaml

kubectl apply -f https://raw.githubusercontent.com/kubernetes/ingress-nginx/main/deploy/static/provider/kind/deploy.yaml
kubectl wait --namespace ingress-nginx \
  --for=condition=ready pod \
  --selector=app.kubernetes.io/component=controller \
  --timeout=90s

helm repo add --force-update postgres-operator https://opensource.zalando.com/postgres-operator/charts/postgres-operator
helm repo add --force-update minio https://charts.min.io
helm repo update

kubectl create ns libresh-system

helm install --namespace $ns postgres-operator postgres-operator/postgres-operator
helm install --namespace $ns minio minio/minio --values ./dev/minio_values.yaml

kubectl apply -k ./dev

if [ -n "$IP" ]; then
sudo sed -i '/dev.local$/d' /etc/hosts
cat << EOF | sudo tee -a /etc/hosts
$IP minio.dev.local
$IP s3.dev.local
$IP keycloak.dev.local
EOF
fi

printf "waiting for minio "
until $(curl --output /dev/null --silent --head --fail http://s3.dev.local/minio/health/live); do
    printf '.'
    sleep 2
done
minio_user=$(kubectl get secret -n libresh-system minio -o jsonpath='{.data.rootUser}' | base64 -d)
minio_pass=$(kubectl get secret -n libresh-system minio -o jsonpath='{.data.rootPassword}' | base64 -d)

kubectl apply -n libresh-system -f - << EOF
---
apiVersion: v1
kind: Secret
metadata:
  name: minio-provider
type: Opaque
stringData:
  username: $minio_user
  password: $minio_pass
---
apiVersion: v1
kind: Secret
metadata:
  name: keycloak
type: Opaque
stringData:
  username: admin
  password: admin
EOF

make install

kubectl apply -n libresh-system -f ./dev/libreconfig.yaml

if [ -x "$(command -v mc)" ]; then
  mc alias set dev http://s3.dev.local $minio_user $minio_pass
fi
