package v1alpha1

import (
	"fmt"

	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
)

// NextcloudSpec defines the desired state of Nextcloud
type NextcloudSpec struct {
	//+required
	Domain string `json:"domain,omitempty"`
	//+optional
	Suspend bool `json:"suspend,omitempty"`
	//+optional
	DefaultApps []string `json:"enabledApps,omitempty"`
	//+optional
	DataLocation string `json:"dataLocation,omitempty"`
}

// NextcloudStatus defines the observed state of Nextcloud
type NextcloudStatus struct {
	//+optional
	Conditions []metav1.Condition `json:"conditions,omitempty"`
}

// +kubebuilder:object:root=true
// +kubebuilder:subresource:status
// +kubebuilder:printcolumn:name="Age",type="date",JSONPath=".metadata.creationTimestamp",description=""
// +kubebuilder:printcolumn:name="Ready",type="string",JSONPath=".status.conditions[?(@.type==\"Ready\")].status",description=""
// +kubebuilder:printcolumn:name="Status",type="string",JSONPath=".status.conditions[?(@.type==\"Ready\")].message",description=""

// Nextcloud is the Schema for the nextclouds API
type Nextcloud struct {
	metav1.TypeMeta   `json:",inline"`
	metav1.ObjectMeta `json:"metadata,omitempty"`

	Spec   NextcloudSpec   `json:"spec,omitempty"`
	Status NextcloudStatus `json:"status,omitempty"`
}

//+kubebuilder:object:root=true

// NextcloudList contains a list of Nextcloud
type NextcloudList struct {
	metav1.TypeMeta `json:",inline"`
	metav1.ListMeta `json:"metadata,omitempty"`
	Items           []Nextcloud `json:"items"`
}

func init() {
	SchemeBuilder.Register(&Nextcloud{}, &NextcloudList{})
}

func (o *Nextcloud) GetConditions() []metav1.Condition {
	return o.Status.Conditions
}

func (o *Nextcloud) SetConditions(conditions []metav1.Condition) {
	o.Status.Conditions = conditions
}

func (o *Nextcloud) Labels() map[string]string {
	return map[string]string{
		// TODO TOFIX ?
		"app.kubernetes.io/component": "app",
		"app.kubernetes.io/instance":  o.Name,
		"app.kubernetes.io/name":      "nextcloud",
		"app.kubernetes.io/part-of":   "Nextcloud",
	}
}

func (o *Nextcloud) SAMLSecretName() string {
	return fmt.Sprintf("%s-saml.nextcloud.libre.sh", o.Name)
}
