package v1alpha1

import (
	"fmt"
	"strings"

	"github.com/Nerzal/gocloak/v11"
)

func (r *Realm) SetDefaults() {
	if r.Spec.Enabled == nil {
		r.Spec.Enabled = gocloak.BoolP(true)
	}

	if r.Spec.RegistrationEmailAsUsername == nil {
		r.Spec.RegistrationEmailAsUsername = gocloak.BoolP(false)
	}

	if r.Spec.InternationalizationEnabled == nil {
		r.Spec.InternationalizationEnabled = gocloak.BoolP(true)
	}

	if len(r.Spec.SupportedLocales) == 0 {
		r.Spec.SupportedLocales = []string{"en", "fr"}
	}

	if r.Spec.RegistrationAllowed == nil {
		r.Spec.RegistrationAllowed = gocloak.BoolP(false)
	}

	if r.Spec.LoginWithEmailAllowed == nil {
		r.Spec.LoginWithEmailAllowed = gocloak.BoolP(true)
	}

	if r.Spec.VerifyEmail == nil {
		r.Spec.VerifyEmail = gocloak.BoolP(true)
	}

	if r.Spec.RememberMe == nil {
		r.Spec.RememberMe = gocloak.BoolP(true)
	}

	if r.Spec.ResetPasswordAllowed == nil {
		r.Spec.ResetPasswordAllowed = gocloak.BoolP(true)
	}

	if r.Spec.EditUsernameAllowed == nil {
		r.Spec.EditUsernameAllowed = gocloak.BoolP(false)
	}

	if r.Spec.DuplicateEmailsAllowed == nil {
		r.Spec.DuplicateEmailsAllowed = gocloak.BoolP(false)
	}

	if r.Spec.DisplayName == "" {
		r.Spec.DisplayName = r.Namespace
	}

	if r.Spec.DisplayNameHTML == "" {
		r.Spec.DisplayNameHTML = r.Namespace
	}

	if r.Spec.RememberMe == nil {
		r.Spec.RememberMe = gocloak.BoolP(true)
	}

	// 1 Day
	if r.Spec.SSOSessionIdleTimeoutRememberMe == "" {
		r.Spec.SSOSessionIdleTimeoutRememberMe = "86400"
	}
	// 7 Days
	if r.Spec.SSOSessionMaxLifespanRememberMe == "" {
		r.Spec.SSOSessionMaxLifespanRememberMe = "604800"
	}

	// 7 Days
	if r.Spec.BruteForceProtected == nil {
		r.Spec.BruteForceProtected = gocloak.BoolP(true)
	}
}

func (r *Realm) MutateRealmRepresentation(realmRepresentation *gocloak.RealmRepresentation) {
	realmRepresentation.Realm = &r.Namespace
	realmRepresentation.Enabled = r.Spec.Enabled
	realmRepresentation.DisplayName = &r.Spec.DisplayName
	realmRepresentation.DisplayNameHTML = &r.Spec.DisplayNameHTML
	realmRepresentation.LoginTheme = &r.Spec.LoginTheme
	realmRepresentation.AccountTheme = &r.Spec.AccountTheme
	realmRepresentation.AdminTheme = &r.Spec.AccountTheme
	realmRepresentation.EmailTheme = &r.Spec.EmailTheme
	realmRepresentation.InternationalizationEnabled = r.Spec.InternationalizationEnabled
	realmRepresentation.SupportedLocales = &r.Spec.SupportedLocales
	realmRepresentation.DefaultLocale = &r.Spec.DefaultLocale
	realmRepresentation.RegistrationAllowed = r.Spec.RegistrationAllowed
	realmRepresentation.RegistrationEmailAsUsername = r.Spec.RegistrationEmailAsUsername
	realmRepresentation.EditUsernameAllowed = r.Spec.EditUsernameAllowed
	realmRepresentation.ResetPasswordAllowed = r.Spec.ResetPasswordAllowed
	realmRepresentation.RememberMe = r.Spec.RememberMe
	realmRepresentation.VerifyEmail = r.Spec.VerifyEmail
	realmRepresentation.LoginWithEmailAllowed = r.Spec.LoginWithEmailAllowed
	realmRepresentation.DuplicateEmailsAllowed = r.Spec.DuplicateEmailsAllowed
	realmRepresentation.BruteForceProtected = r.Spec.BruteForceProtected

	if len(r.Spec.ContentSecurityPolicy) > 0 {
		browserSecurityHeaders := *realmRepresentation.BrowserSecurityHeaders
		browserSecurityHeaders["contentSecurityPolicy"] = fmt.Sprintf("frame-src 'self' %[1]s; frame-ancestors 'self' %[1]s; object-src 'none';", strings.Trim(fmt.Sprint(r.Spec.ContentSecurityPolicy), "[]"))

		realmRepresentation.BrowserSecurityHeaders = &browserSecurityHeaders
	}

	// TODO
	// SsoSessionIdleTimeoutRememberMe: ,
	//	SSOSessionMaxLifespanRememberMe

	// TODO Metrics

}
