package v1alpha1

import (
	"github.com/Nerzal/gocloak/v11"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
)

// OIDCClientSpec defines the desired state of OIDCClient
type OIDCClientSpec struct {
	Suspend                 bool     `json:"suspend,omitempty"`
	ClientID                string   `json:"clientID,omitempty"`
	Enabled                 *bool    `json:"enabled,omitempty"`
	AccessType              string   `json:"accessType,omitempty"`
	BaseURL                 string   `json:"baseURL,omitempty"`
	RedirectURIs            []string `json:"redirectURIs,omitempty"`
	Public                  *bool    `json:"public,omitempty"`
	Realm                   string   `json:"realm,omitempty"`
	ClientAuthenticatorType string   `json:"clientAuthenticatorType,omitempty"`
}

// OIDCClientStatus defines the observed state of OIDCClient
type OIDCClientStatus struct {
	//+optional
	Conditions []metav1.Condition `json:"conditions,omitempty"`
}

//+kubebuilder:object:root=true
//+kubebuilder:subresource:status
// +kubebuilder:printcolumn:name="Age",type="date",JSONPath=".metadata.creationTimestamp",description=""
// +kubebuilder:printcolumn:name="Ready",type="string",JSONPath=".status.conditions[?(@.type==\"Ready\")].status",description=""
// +kubebuilder:printcolumn:name="Status",type="string",JSONPath=".status.conditions[?(@.type==\"Ready\")].message",description=""

// OIDCClient is the Schema for the oidcclients API
type OIDCClient struct {
	metav1.TypeMeta   `json:",inline"`
	metav1.ObjectMeta `json:"metadata,omitempty"`

	Spec   OIDCClientSpec   `json:"spec,omitempty"`
	Status OIDCClientStatus `json:"status,omitempty"`
}

//+kubebuilder:object:root=true

// OIDCClientList contains a list of OIDCClient
type OIDCClientList struct {
	metav1.TypeMeta `json:",inline"`
	metav1.ListMeta `json:"metadata,omitempty"`
	Items           []OIDCClient `json:"items"`
}

func init() {
	SchemeBuilder.Register(&OIDCClient{}, &OIDCClientList{})
}

func (o *OIDCClient) GetConditions() []metav1.Condition {
	return o.Status.Conditions
}

func (o *OIDCClient) SetConditions(conditions []metav1.Condition) {
	o.Status.Conditions = conditions
}

func (o *OIDCClient) SetDefaults() {
	if o.Spec.Enabled == nil {
		o.Spec.Enabled = gocloak.BoolP(true)
	}
	if len(o.Spec.ClientID) == 0 {
		o.Spec.ClientID = o.Name
	}
	if o.Spec.Public == nil {
		o.Spec.Public = gocloak.BoolP(false)
	}
	if len(o.Spec.Realm) == 0 {
		o.Spec.Realm = o.Namespace
	}
	if len(o.Spec.ClientAuthenticatorType) == 0 {
		o.Spec.ClientAuthenticatorType = "client-secret"
	}

}
