package v1alpha1

import (
	"fmt"
	"strings"

	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
)

const ZalandoTeam = "pg"

// PostgresSpec defines the desired state of Postgres
type PostgresSpec struct {
	//+optional
	Suspend bool `json:"suspend,omitempty"`
}

// PostgresStatus defines the observed state of Postgres
type PostgresStatus struct {
	//+optional
	Conditions []metav1.Condition `json:"conditions,omitempty"`
}

//+kubebuilder:object:root=true
//+kubebuilder:subresource:status
//+kubebuilder:printcolumn:name="Age",type="date",JSONPath=".metadata.creationTimestamp",description=""
//+kubebuilder:printcolumn:name="Ready",type="string",JSONPath=".status.conditions[?(@.type==\"Ready\")].status",description=""
//+kubebuilder:printcolumn:name="Status",type="string",JSONPath=".status.conditions[?(@.type==\"Ready\")].message",description=""

// Postgres is the Schema for the Postgres API
type Postgres struct {
	metav1.TypeMeta   `json:",inline"`
	metav1.ObjectMeta `json:"metadata,omitempty"`

	Spec   PostgresSpec   `json:"spec,omitempty"`
	Status PostgresStatus `json:"status,omitempty"`
}

//+kubebuilder:object:root=true

// PostgresList contains a list of Postgres
type PostgresList struct {
	metav1.TypeMeta `json:",inline"`
	metav1.ListMeta `json:"metadata,omitempty"`
	Items           []Postgres `json:"items"`
}

func init() {
	SchemeBuilder.Register(&Postgres{}, &PostgresList{})
}

func (o *Postgres) GetConditions() []metav1.Condition {
	return o.Status.Conditions
}

func (o *Postgres) SetConditions(conditions []metav1.Condition) {
	o.Status.Conditions = conditions
}

func (postgres *Postgres) DatabaseName() string {
	return strings.ReplaceAll(postgres.Name, "-", "_")
}

func (postgres *Postgres) UserName() string {
	return strings.ReplaceAll(postgres.Name, "-", "_")
}

func (postgres *Postgres) GetZalandoName() string {
	return fmt.Sprintf("%s-%s", ZalandoTeam, postgres.GetName())
}

func (postgres *Postgres) SecretName() string {
	return fmt.Sprintf("%s.postgres.libre.sh", postgres.Name)
}
