package internal

import (
	"context"
	"strconv"

	"github.com/Nerzal/gocloak/v11"
	corev1 "k8s.io/api/core/v1"
	"k8s.io/apimachinery/pkg/types"
	librecorev1alpha1 "libre.sh/controller/apis/core/v1alpha1"
	"sigs.k8s.io/controller-runtime/pkg/client"
)

func MutateOIDCClientRepresentation(oidcClient librecorev1alpha1.OIDCClient, clientRepresentation *gocloak.Client) {
	clientRepresentation.Protocol = gocloak.StringP("openid-connect")
	clientRepresentation.Name = &oidcClient.Name
	clientRepresentation.Enabled = oidcClient.Spec.Enabled
	clientRepresentation.ClientID = &oidcClient.Spec.ClientID
	clientRepresentation.PublicClient = oidcClient.Spec.Public
	clientRepresentation.BaseURL = &oidcClient.Spec.BaseURL
	clientRepresentation.RedirectURIs = &oidcClient.Spec.RedirectURIs

	clientRepresentation.DefaultClientScopes = &[]string{"groups"}
}

func MutateSAMLClientRepresentation(ctx context.Context, client client.Client, samlClient librecorev1alpha1.SAMLClient, clientRepresentation *gocloak.Client) error {
	clientRepresentation.Protocol = gocloak.StringP("saml")
	clientRepresentation.Enabled = samlClient.Spec.Enabled
	clientRepresentation.ClientID = &samlClient.Spec.ClientID
	clientRepresentation.Name = &samlClient.Name
	clientRepresentation.RedirectURIs = &samlClient.Spec.RedirectURIs

	attributes := map[string]string{
		"saml.assertion.signature": strconv.FormatBool(samlClient.Spec.AssertionSignature),
		// TODO
		//	"saml.signing.certificate":                string(secret.Data["tls.crt"]),
		"saml_single_logout_service_url_redirect": samlClient.Spec.SingleLogoutServiceURLRedirect,
		"saml.signature.algorithm":                samlClient.Spec.SignatureAlgorithm,
		"saml.client.signature":                   strconv.FormatBool(samlClient.Spec.ClientSignature),
		"saml.authnstatement":                     strconv.FormatBool(samlClient.Spec.AuthnStatement),
		"saml_assertion_consumer_url_post":        samlClient.Spec.AssertionConsumerURLPost,
		"saml_single_logout_service_url_post":     samlClient.Spec.SingleLogoutServiceURLPost,
		"saml_name_id_format":                     samlClient.Spec.NameIDFormat,
		"saml.server.signature":                   strconv.FormatBool(samlClient.Spec.ServerSignature),
		"saml.server.signature.keyinfo.ext":       strconv.FormatBool(samlClient.Spec.ServerSignatureKeyInfoExt),
		"fullScopeAllowed":                        strconv.FormatBool(samlClient.Spec.FullScopeAllowed),
	}

	var secret corev1.Secret
	err := client.Get(ctx, types.NamespacedName{Namespace: samlClient.Namespace, Name: samlClient.Spec.SigningCertificateSecretName}, &secret)
	if err != nil {
		return err
	}
	attributes["saml.signing.certificate"] = string(secret.Data["tls.crt"])

	clientRepresentation.Attributes = &attributes

	mappers := []gocloak.ProtocolMapperRepresentation{}
	for _, mapper := range samlClient.Spec.ProtocolMappers {
		m := gocloak.ProtocolMapperRepresentation{
			Name:           gocloak.StringP(mapper.Name),
			Protocol:       gocloak.StringP(mapper.Protocol),
			ProtocolMapper: gocloak.StringP(mapper.ProtocolMapper),
			// Config:          mapper.Config,
		}
		mapperConfig := map[string]string{}
		for k, v := range mapper.Config {
			mapperConfig[k] = v
		}
		m.Config = &mapperConfig
		mappers = append(mappers, m)
	}

	clientRepresentation.ProtocolMappers = &mappers

	return nil
}
