package v1alpha1

import (
	corev1 "k8s.io/api/core/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
)

// LibreConfigSpec defines the desired state of LibreConfig
type LibreConfigSpec struct {
	// Keycloak provider
	// +optinal
	Keycloak *Provider `json:"keycloak,omitempty"`
	// Data ObjectStore provider
	// +optinal
	DataObjectStore *Provider `json:"dataObjectStore,omitempty"`
	// Backup ObjectStore provider
	// +optional
	BackupObjectStore *Provider `json:"backupObjectStore,omitempty"`
	// Email provider
	// +optinal
	Email *Provider `json:"email,omitempty"`
}

type Provider struct {
	// Keycloak host url
	// +required
	Host string `json:"hostname,omitempty"`
	// Secret reference with information for to connect to the api. Keys must be - username, password
	// +required
	Credentials *corev1.LocalObjectReference `json:"credentials,omitempty"`
}

// LibreConfigStatus defines the observed state of LibreConfig
type LibreConfigStatus struct {
}

//+kubebuilder:object:root=true
//+kubebuilder:subresource:status

// LibreConfig is the Schema for the libreconfigs API
type LibreConfig struct {
	metav1.TypeMeta   `json:",inline"`
	metav1.ObjectMeta `json:"metadata,omitempty"`

	Spec   LibreConfigSpec   `json:"spec,omitempty"`
	Status LibreConfigStatus `json:"status,omitempty"`
}

//+kubebuilder:object:root=true

// LibreConfigList contains a list of LibreConfig
type LibreConfigList struct {
	metav1.TypeMeta `json:",inline"`
	metav1.ListMeta `json:"metadata,omitempty"`
	Items           []LibreConfig `json:"items"`
}

func init() {
	SchemeBuilder.Register(&LibreConfig{}, &LibreConfigList{})
}
