package v1alpha1

import (
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
)

// EDIT THIS FILE!  THIS IS SCAFFOLDING FOR YOU TO OWN!
// NOTE: json tags are required.  Any new fields you add must have json tags for the fields to be serialized.

// RocketChatSpec defines the desired state of RocketChat
type RocketChatSpec struct {
	Domain string `json:"domain,omitempty"`
	//+optional
	EnableOAuth bool `json:"enableOAuth,omitempty"`
}

// RocketChatStatus defines the observed state of RocketChat
type RocketChatStatus struct {
	// INSERT ADDITIONAL STATUS FIELD - define observed state of cluster
	// Important: Run "make" to regenerate code after modifying this file
}

//+kubebuilder:object:root=true
//+kubebuilder:subresource:status

// RocketChat is the Schema for the rocketchats API
type RocketChat struct {
	metav1.TypeMeta   `json:",inline"`
	metav1.ObjectMeta `json:"metadata,omitempty"`

	Spec   RocketChatSpec   `json:"spec,omitempty"`
	Status RocketChatStatus `json:"status,omitempty"`
}

//+kubebuilder:object:root=true

// RocketChatList contains a list of RocketChat
type RocketChatList struct {
	metav1.TypeMeta `json:",inline"`
	metav1.ListMeta `json:"metadata,omitempty"`
	Items           []RocketChat `json:"items"`
}

func init() {
	SchemeBuilder.Register(&RocketChat{}, &RocketChatList{})
}
