package v1alpha1

import (
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
)

// RealmSpec defines the desired state of Realm
type RealmSpec struct {
	// Realm Name, default to metada.name
	Name string `json:"name,omitempty"`
	// Is Realm enabled
	// +optional
	Enabled bool `json:"enabled,omitempty"`
	// Realm display name.
	// +optional
	DisplayName string `json:"displayName"`
	// Realm HTML display name.
	// +optional
	DisplayNameHTML string `json:"displayNameHtml,omitempty"`
	// Are metrics enabled
	// +optional
	Metrics bool `json:"metrics,omitempty"`

	// Login Theme
	// +optional
	LoginTheme string `json:"loginTheme,omitempty"`
	// Account Theme
	// +optional
	AccountTheme string `json:"accountTheme,omitempty"`
	// Admin Console Theme
	// +optional
	AdminTheme string `json:"adminTheme,omitempty"`
	// Email Theme
	// +optional
	EmailTheme string `json:"emailTheme,omitempty"`
	// Internationalization Enabled
	// +optional
	InternationalizationEnabled *bool `json:"internationalizationEnabled,omitempty"`
	// Supported Locales
	// +optional
	SupportedLocales []string `json:"supportedLocales,omitempty"`
	// Default Locale
	// +optional
	DefaultLocale string `json:"defaultLocale,omitempty"`

	// User registration
	// +optional
	RegistrationAllowed *bool `json:"registrationAllowed,omitempty"`
	// Email as username
	// +optional
	RegistrationEmailAsUsername *bool `json:"registrationEmailAsUsername,omitempty"`
	// Edit username
	// +optional
	EditUsernameAllowed *bool `json:"editUsernameAllowed,omitempty"`
	// Forgot password
	// +optional
	ResetPasswordAllowed *bool `json:"resetPasswordAllowed,omitempty"`
	// Remember me
	// +optional
	RememberMe *bool `json:"rememberMe,omitempty"`
	// Verify email
	// +optional
	VerifyEmail *bool `json:"verifyEmail,omitempty"`
	// Login with email
	// +optional
	LoginWithEmailAllowed *bool `json:"loginWithEmailAllowed,omitempty"`
	// Duplicate emails
	// +optional
	DuplicateEmailsAllowed *bool `json:"duplicateEmailsAllowed,omitempty"`

	// Default to 1 Day
	// +optional
	SSOSessionIdleTimeoutRememberMe string `json:"ssoSessionIdleTimeoutRememberMe,omitempty"`
	// Default to 7 Days
	// +optional
	SSOSessionMaxLifespanRememberMe string `json:"ssoSessionMaxLifespanRememberMe,omitempty"`

	// Authorized domains for Content Security Policy
	// +optional
	ContentSecurityPolicy []string `json:"contentSecurityPolicy,omitempty"`
}

/*
r.RegistrationEmailAsUsername = gocloak.BoolP(false)

	r.InternationalizationEnabled = gocloak.BoolP(true)

	r.SupportedLocales = &[]string{"fr", "en"}

	r.RegistrationAllowed = gocloak.BoolP(false)

	r.LoginWithEmailAllowed = gocloak.BoolP(true)

	r.VerifyEmail = gocloak.BoolP(true)

	r.RememberMe = gocloak.BoolP(true)

	r.ResetPasswordAllowed = gocloak.BoolP(true)

	r.EditUsernameAllowed = gocloak.BoolP(false)

	r.DuplicateEmailsAllowed = gocloak.BoolP(false)

	r.DisplayName = gocloak.StringP(strings.Replace(conf.Domain, ".", "-", -1))

	r.DisplayNameHTML = gocloak.StringP(strings.Replace(conf.Domain, ".", "-", -1))

	r.AdminTheme = gocloak.StringP("liiibre")

	r.EmailTheme = gocloak.StringP("liiibrelite")

	r.LoginTheme = gocloak.StringP("liiibrelite")

	r.AccountTheme = gocloak.StringP("liiibre")

	r.RememberMe = gocloak.BoolP(true)

	r.BruteForceProtected = gocloak.BoolP(true)

	// 1 Day
	r.SsoSessionIdleTimeoutRememberMe = gocloak.IntP(86400)
	// 7 Days
	r.SsoSessionMaxLifespanRememberMe = gocloak.IntP(604800)

	browserSecurityHeaders := map[string]string{
		"xContentTypeOptions": "nosniff",
		"xRobotsTag":          "none",
		"xFrameOptions":       "SAMEORIGIN",
		// TODO
		"contentSecurityPolicy":   fmt.Sprintf("frame-src 'self' %s; frame-ancestors 'self' %s; object-src 'none';", conf.Nextcloud.GetURL(), conf.Nextcloud.GetURL()),
		"xXSSProtection":          "1; mode=block",
		"strictTransportSecurity": "max-age=31536000; includeSubDomains",
	}

	r.BrowserSecurityHeaders = &browserSecurityHeaders

	secret := &corev1.Secret{}
	err := k8sCLI.Get(context.TODO(), client.ObjectKey{
		Namespace: conf.Keycloak.Realm,
		Name:      fmt.Sprintf("%s-smtp", conf.Keycloak.Realm)},
		secret)
	if err != nil {
		// TODO manage error, if secret does not exist skip ?
		return err
	}

	smtp := map[string]string{
		"auth":     strconv.FormatBool(true),
		"user":     string(secret.Data["username"]),
		"from":     string(secret.Data["username"]),
		"password": string(secret.Data["password"]),
		"host":     string(secret.Data["host"]),
		"Host":     string(secret.Data["host"]),
		"port":     string(secret.Data["port"]),
		"Port":     string(secret.Data["port"]),
		"starttls": strconv.FormatBool(true),
	}

	r.SMTPServer = &smtp

	r.PasswordPolicy = gocloak.StringP("length(12) and notUsername(undefined) and passwordHistory(3)")

	return nil
*/

// RealmStatus defines the observed state of Realm
type RealmStatus struct {
	// INSERT ADDITIONAL STATUS FIELD - define observed state of cluster
	// Important: Run "make" to regenerate code after modifying this file
}

//+kubebuilder:object:root=true
//+kubebuilder:subresource:status

// Realm is the Schema for the realms API
type Realm struct {
	metav1.TypeMeta   `json:",inline"`
	metav1.ObjectMeta `json:"metadata,omitempty"`

	Spec   RealmSpec   `json:"spec,omitempty"`
	Status RealmStatus `json:"status,omitempty"`
}

//+kubebuilder:object:root=true

// RealmList contains a list of Realm
type RealmList struct {
	metav1.TypeMeta `json:",inline"`
	metav1.ListMeta `json:"metadata,omitempty"`
	Items           []Realm `json:"items"`
}

func init() {
	SchemeBuilder.Register(&Realm{}, &RealmList{})
}
