Create a file with the list of fileid you want to reupload the size:

```
psql -U postgres -d nextcloud -t -c  "select fileid from filecache where size=0 and mimetype !=2 and ...;" | sed -r 's/\s+//g' > ./files_to_reconcile
```

Then, create a csv with the fileid and the size:

```
export MC_HOST_host

rm ./uid_with_size.csv
touch ./uid_with_size.csv

for uid in `cat ./files_to_reconcile`; do
  # the select key is necessary because, if say uid =1234, mc ls uid will return objects 1234 and 12341, 12342, 12343 and so on.. so with the select key, we double check we have the desired object.
  size=`mc ls host/bucket/urn:oid:$uid --json | jq '. | select(.key=="urn:oid:'$uid'").size'`
  # you can do the same with checksums
  # checksum=`mc cat host/bucket/urn:oid:$uid | sha1sum | cut -d" " -f1`
  echo $uid,$size >> ./uid_with_size.csv
done
```

And finally, import this csv in a temp table, and update the filecache table accordingly:

```
CREATE TEMP TABLE tmp_x (fileid int, size int);
COPY tmp_x FROM '/home/postgres/uid_with_size.csv' (FORMAT csv);

UPDATE filecache
SET    size = tmp_x.size
FROM   tmp_x
WHERE  filecache.fileid = tmp_x.fileid;
```
