Clean snapshots older than 2 months in a namespace:

```
kubectl get snapshots.kubedb.com -o go-template --template '{{range .items}}{{.metadata.name}} {{.metadata.creationTimestamp}}{{"\n"}}{{end}}' | awk '$2 <= "'$(date -d '2 month ago' -Ins --utc | sed 's/+0000/Z/')'" { print $1 }'  | xargs --no-run-if-empty kubectl delete snapshots.kubedb.com
```

Clean snapshots older than 2 months in all namespaces:

```
for ns in `kubectl get snapshots.kubedb.com -o go-template --template '{{range .items}}{{.metadata.namespace}}{{"\n"}}{{end}}' -A | uniq`; do
  kubens $ns
  kubectl get snapshots.kubedb.com -o go-template --template '{{range .items}}{{.metadata.name}} {{.metadata.creationTimestamp}}{{"\n"}}{{end}}' | awk '$2 <= "'$(date -d '2 month ago' -Ins --utc | sed 's/+0000/Z/')'" { print $1 }'  | xargs --no-run-if-empty kubectl delete snapshots.kubedb.com;
done
```