First get the folders you are looking for in the activity app:

```
psql -U postgres -d nextcloud -t -c  "select file from activity a where a.type='file_deleted' and a.user='xxx' and a.affecteduser='xxx' and file LIKE '/xx%xxx%' and timestamp > 1642593600 and timestamp < 1642597200;" > ./folders
```

Then start an rclone container and:

```
export URL_FROM=nuage-restore.xxx
export USER_FROM=xxx
export PASS_FROM=yyy
export URL_TO=nuage.xxx
export USER_TO=$USER_FROM
export PASS_TO=yyy

export RCLONE_CONFIG_FROM_URL=https://$URL_FROM/remote.php/dav/files/$USER_FROM
export RCLONE_CONFIG_FROM_USER=$USER_FROM
export RCLONE_CONFIG_FROM_PASS=`rclone obscure $PASS_FROM`
export RCLONE_CONFIG_FROM_TYPE=webdav
export RCLONE_CONFIG_FROM_VENDOR=nextcloud

export RCLONE_CONFIG_TO_URL=https://$URL_TO/remote.php/dav/files/$USER_TO
export RCLONE_CONFIG_TO_USER=$USER_TO
export RCLONE_CONFIG_TO_PASS=`rclone obscure $PASS_TO`
export RCLONE_CONFIG_TO_TYPE=webdav
export RCLONE_CONFIG_TO_VENDOR=nextcloud
```

Make sure you can list properly the source folders:
```
while read p; do
  rclone lsd from:"$p"
done <folders
```

And that the destination folders are still empty and that you get the good count of folders:
```
while read p; do
  rclone lsd to:"$p"
done <folders 2>&1 | grep ERROR | wc -l
```

Then sync them:
```
while read p; do
  rclone sync --progress from:"$p" to:"$p"
done <folders
```