# How to restore in a new instance

## Prepare the env

 - [copy secret](https://lab.libreho.st/libre.sh/kubernetes/procedures/-/blob/master/kubernetes/manipulate-secrets.md) and cm for the app
   - cm `${FQDN}-config`
   - cm `${FQDN}-config`
   - secret `${FQDN}-oidc`
   - secret `${FQDN}-app`
   - secret `${FQDN}-s3`
 - copy secret for mongo, as explained [in the doc](https://github.com/percona/percona-server-mongodb-operator/blob/1.10.0-docs/source/backups.rst#restore-the-cluster-from-a-previously-saved-backup=)
   - secret `${FQDN}-mongodb-users`
 - cd domains/DOMAIN
 - mkdir restore
 - cd restore
 - change the 2 (regular and oplog) mongo url in secret `${FQDN}-app` to point to the new cluster that you will deploy

## Deploy the env

 - libre apply ../../common/rocketchat/manifests/mongo.yml

Wait the cluster to be ready and make the restore and apply it:

```
k get psmdb
$ cat restore.yml
apiVersion: psmdb.percona.com/v1
kind: PerconaServerMongoDBRestore
metadata:
  name: restore-instance-date
spec:
  clusterName: chat-restore-domain
  backupName: cron-chat-domain-date-hash

$ k apply -f restore.yml
```

Wait the restore to be complete
```
k get psmdb-restore
```

And lauch your app server:
```
libre apply  ../../common/rocketchat/manifests/app.yml
```

And modify the ingress to use your subdomain, in our case, `liiib.re` instead of users subdoamin.

Congrats you have a restored version of RocketChat :)

Now to login, paste this in your js console in your nav:
```
Meteor.loginWithPassword('admin', 'your-password')
```
