# Restore a user from a dump

## Dump atomic user data

### Run a local postgres

1. Get the logical dump.
2. Get the posgres credentials from production.

```bash
export PGPASSWORD=...
```

3. Start the database.

```bash
podman run --rm -p 5432:5432 -e POSTGRES_PASSWORD="$PGPASSWORD" postgres:12
```

4. Restore from the logical backup

```bash
psql -h localhost -U postgres < ./logical_backup.sql
```

### Export user data

1. Find the user id

```shell
psql -h localhost -U postgres -d hedgedoc -c "select id,profile from \"Users\" where profile like '%EMAIL_OR_USERNAME%';"
```

2. Export Users table

```shell
psql -h localhost -U postgres -d hedgedoc -c "copy (select * from \"Users\" where id='USER_ID') to stdout;" > backup_users
```

3. Export Notes table

```shell
psql -h localhost -U postgres -d hedgedoc -c "copy (select * from \"Notes\" where \"ownerId\"='USER_ID') to stdout;" > backup_notes
```

4. Export Authors table

```shell
psql -h localhost -U postgres -d hedgedoc -c "copy (select * from \"Authors\" where \"userId\"='USER_ID') to stdout;" > backup_authors
```

4. Export Revisions table

```shell
psql -h localhost -U postgres -d hedgedoc -c "copy (select \"Revisions\".* from \"Revisions\" join \"Notes\" on \"Revisions\".\"noteId\"=\"Notes\".id where \"Notes\".\"ownerId\"='USER_ID') to stdout;" > backup_revisions
```

## Restore atomic user data

1. Stop the local database.
2. Forward the production database (with kubectl).
3. Import Users table

```shell
psql -h localhost -U postgres -d hedgedoc -c "copy \"Users\" from stdin;" < backup_users
```

4. Import Notes table

```shell
psql -h localhost -U postgres -d hedgedoc -c "copy \"Notes\" from stdin;" < backup_notes
```

5. Import Authors table

```shell
psql -h localhost -U postgres -d hedgedoc -c "copy \"Authors\" from stdin;" < backup_authors
```

6. Import Revisions table

```shell
psql -h localhost -U postgres -d hedgedoc -c "copy \"Revisions\" from stdin;" < backup_revisions
```
