# Postgres Operator

## When space if full 

https://www.postgresql.fastware.com/blog/how-to-solve-the-problem-if-pg_xlog-is-full

### how to fix

 - delete logs in ~/pg_data/pgroot/pg_logs
 - wait that the leader starts
 - patronictl reinit cluster_name secondary_member_name
 - patronictl switchover
 - patronictl reinit cluster_name new_secondary_member_name

### To prevent full space

```
cd /home/postgres/pgdata
fallocate -l 150M ./to-delete-if-full-1
fallocate -l 150M ./to-delete-if-full-2
```

### check /home/postgres/pgdata/pgroot/data/pg_wal

If it is full, it probably means it couldn't upload wals.

check logs to see if there is an error with backups.

Fix the errors.

Try to delete some logs or other and restart the process.


It should be fine.

### Log eating all the space

By default spilo postgres is configured with:
```
  postgresql:
    parameters:
      log_connections: "on"
      log_disconnections: "on"
```

If logs are eating space, you can change it to off in the crd.

